# -*- coding: utf-8 -*-
"""
Created on Thu Aug 13 11:58:06 2015

Analytical solution to Advection-dispersion equation (longitudinal dispersion) 
Instantaneous Point Injection (Fischer 1973)

M:              Mass discharged (kg/m3)
area:           Channel cross-sectional area (m2) - array of areas of the river for each time and location
Dx:             Dispersion in the longitudinal direction (m2/s)
t_transport:    Time at which concentration is calculated (min)
i:              Reach number 
velocity:       Velocity of river (m/day) - array of velocities of the river for each time and location

Solution is valid only when x >> 10L where L = length of the advective zone
Units are customized to fit CMF model 

@author: ci1vcs
"""

def ADE_Longitudinal_Dispersion(M, Dx, velocity, area, t_settle, ADomain):
    
    x_values = ADomain.X.InclusiveRange()
    time_values = ADomain.Time.InclusiveRange()

    x_length = ADomain.X.NumberOfSteps()
    y_length = ADomain.Y.NumberOfSteps()
    time_length = ADomain.Time.NumberOfSteps()

    x_step = ADomain.X.Step
    
    import math
    import numpy as np
    C = np.zeros((x_length, y_length, time_length), float)
    initial_concentration = M / (x_step * area)
    C[0,:,0] = initial_concentration
    
    for time_index in np.arange(1,time_length):
        t = time_values[time_index] - t_settle
        for x_index in np.arange(0,x_length):
            x = x_values[x_index]            

            #C[x_index,:,time_index] =  initial_concentration * x_step/(math.sqrt(4*math.pi*Dx*t)) * math.exp(-(x - (velocity*t))**2./(4.*Dx*t))
            
            # old method using mass and area
            C[x_index,:,time_index] =  M/(area * math.sqrt(4*math.pi*Dx*t)) * math.exp(-(x - (velocity*t))**2./(4.*Dx*t))
            
    return C
    
     
